# Project Repository Map (FrisiLogix)

This map explains the structure, key responsibilities, and important behavior/policy decisions. It reflects the current state after the latest legal/UX/security updates.

## High‑Level
- Bilingual site (DE/EN) under `de/` and `en/`.
- No tracking/marketing cookies. Only technically necessary cookies (e.g., CSRF token) are used. Therefore no cookie banner is shown (TTDSG § 25(2)).
- Contact form: minimal client validation; server prefers SMTP if configured; otherwise stores messages to `logs/outbox/`.

## Root (`/var/www/html/frisilogix`)
- `index.php` – Language router to `/de/` or `/en/`.
- `content.de.json`, `content.en.json` – Localized text content used by pages.
- `send_mail.php` – Form backend (SMTP mailer with safe outbox fallback). Loads `.env` automatically if present.
- `robots.txt`, `sitemap.xml` – SEO assets.
- `REPORT.md`, `seo_audit_report.md`, `REPO_MAP.md` – Documentation.

## Assets (`assets/`)
- `images/` – Favicons, product/hero imagery.
- `videos/` – Background/section videos (e.g., `uClean_compact.mp4`).

## Styles (`css/`)
- `base.css` – Variables, base styles, resets.
- `layout.css` – Global layout, header/nav responsiveness, hero video container, grids.
- `components.css` – Reusable UI: CTA buttons, footer links, contact modal, call bar, etc.
  - Footer: active link (`.footer__item a.active`) mirrors hover style for current page indication.
  - Header CTA: `.header-contact-btn` rendered on desktop and slightly smaller than default CTAs.
- `forms.css` – Contact form layout; minimal consent row styling (informational only).
- `hero.css`, `features.css`, `footer.css` – Section‑specific refinements.
- `cookie-banner.css` – Legacy cookie banner styles (currently unused; kept for potential future CMP).
- `fonts.css` – Font faces.

## Includes (`includes/`)
- `header.php` – Global header and primary navigation.
  - Header contact CTA is always rendered (desktop); mobile hidden via CSS for space.
  - Hreflang/canonical and language switching helpers integrated.
- `footer.php` – Global footer.
  - Imprint/Privacy links with active state highlighting based on current path.
  - No persistent cookie notice; privacy pages describe necessary‑only cookies.
- `content.php` – UI labels and content helpers (features, phone number, etc.).
- `i18n.php` – Language detection and URL helpers (switching, `relativePathWithoutLang()`, `basePath()`).

## Pages (`de/`, `en/`)
- `index.php` – Homepages with hero background video, typewriter headings, features and robots sections.
- `impressum.php` / `imprint.php` – Legal notice.
  - Uses § 5 DDG (DE/EN clarified).
  - Responsibility wording uses § 18(2) MStV (EN page).
  - VAT ID section removed until one is assigned.
- `datenschutz.php` / `privacy.php` – Privacy policy.
  - States “only technically necessary cookies”, no tracking/marketing cookies.
  - Server logs documented (purposes, Art. 6(1)(f) GDPR; regular deletion; all‑inkl.com as processor).
  - Social networks (LinkedIn) noted: only a simple link, no embeds, no cookies until clicked.
- `integration.php`, `about.php`/`ueber.php`, `thanks.php`/`danke.php` – Additional content pages.

## JavaScript (`js/`)
- `main.js` – Bootstrap initialization: utils, header, hero, features, banner, navigation (mobile + desktop), contact form, mobile call bar. Hero starts immediately (no consent gating).
- `hero.js` – Hero typewriter and hero video handling; emits events for CTA/indicator.
- `banner.js` – Feature banner behavior and section video play/pause.
- `navigation.js` – Mobile overlay menu + dropdown handling.
- `navDesktop.js` – Desktop dropdown interactions.
- `header.js` – Header visual state and metrics.
- `contactForm.js` – Contact modal UX & form submission; sets CSRF token cookie/hidden field.
- `mobileCallBar.js` – Mobile sticky call bar.
- `utils.js` – Shared utilities.
- `cookieConsent.js` – Kept for potential future CMP, currently not used.

## Security
- Basic input validation server‑side (required fields + email format).
- Honeypot field `website` present in form markup (no SMTP; messages are stored locally).

### Mail/SMTP settings
- `MAIL_TO` – one or more recipient addresses (comma/semicolon/space separated). If unset, falls back to config `mail.to`.
- `SMTP_HOST`, `SMTP_PORT`, `SMTP_SECURE` (`tls`/`ssl`/`none`), `SMTP_USER`, `SMTP_PASS`, `SMTP_FROM`, `SMTP_FROM_NAME` (optional), `SMTP_DEBUG` (optional).
  - If `SMTP_HOST` and `SMTP_FROM` are present, the app tries SMTP; on failure it logs the error and stores the message to the outbox.

You can copy `.env.example` to `.env` and fill in your credentials. The app will pick it up automatically.

## Consent & Cookies Policy
- Current stance: necessary‑only cookies, no tracking. No cookie banner needed (TTDSG § 25(2)).
- If analytics/marketing/embeds are added later, re‑enable a CMP:
  - Granular purposes (analytics/marketing/comfort), equal buttons, persistent “Cookie settings” link in footer, consent logging; load third‑party scripts only after opt‑in.

## UX Notes
- Footer active page highlighting implemented in `includes/footer.php` (using `relativePathWithoutLang()`).
- Header contact CTA always present on desktop (removed suppression on hero page).
- Contact form legal basis: informational notice (Art. 6(1)(b) GDPR) instead of forced consent checkbox.

## Accessibility (A11y)
- Structure uses semantic tags and ARIA where needed.
- Consider future enhancements: `prefers-reduced-motion` handling for hero/typewriter, consistent focus outlines, color contrast checks.
