<?php
$page_title = 'FAQ';
include __DIR__ . '/../includes/header.php';
include_once __DIR__ . '/../includes/i18n.php';
$base = basePath();
?>

<div class="content-page legal-page faq-page">
  <div class="container">
    <h1>FAQ</h1>

    <section>
      <h2>Allgemein</h2>
      <h3>Was macht FrisiLogix?</h3>
      <p>FrisiLogix berät, integriert und schult rund um mobile Robotik (AMR/AGV) – pragmatisch und zukunftssicher. Zusätzlich verkauft FrisiLogix Systeme und bietet RaaS (Robotics as a Service) an.</p>

      <h3>Für wen ist das Angebot gedacht?</h3>
      <p>Für Unternehmen, die innerbetriebliche Transporte oder Reinigungsprozesse automatisieren möchten – vom ersten Konzept über die Integration bis hin zu Service‑ und Wartungsarbeiten im laufenden Betrieb.</p>
    </section>

    <section>
      <h2>Leistung & Ablauf</h2>
      <h3>Wie läuft ein typisches Projekt ab?</h3>
      <p>In der Regel in drei Schritten: 1) kurze Bedarfsaufnahme, 2) Planung/Pilotierung, 3) Integration & Schulung. Schlank, transparent und mit klaren Meilensteinen.</p>


      <h3>Wie schnell kann gestartet werden?</h3>
      <p>Erstgespräch kurzfristig. Pilotierungen häufig in wenigen Wochen möglich – abhängig von Materialverfügbarkeit und Infrastruktur vor Ort.</p>
    </section>

    <section>
      <h2>Kosten & Angebot</h2>
      <h3>Was kostet das?</h3>
      <p>Das hängt von Use Case, Umgebung und Funktionsumfang ab. FrisiLogix erstellt gern ein unverbindliches Angebot nach einer kurzen Bedarfsaufnahme.</p>

      <h3>Gibt es eine Vor-Ort-Begehung?</h3>
      <p>Ja, sofern sinnvoll. Alternativ startet FrisiLogix remote und prüft anschließend den Bedarf für einen Vor-Ort-Termin.</p>
    </section>

    <section>
      <h2>Technik & Betrieb</h2>
      <h3>Gibt es Unterstützung nach der Inbetriebnahme?</h3>
      <p>Ja. FrisiLogix bietet Support, Schulung und Optimierung im laufenden Betrieb – je nach Vereinbarung.</p>

      <h3>Kompatibilität & Sicherheit</h3>
      <p>FrisiLogix achtet auf saubere Schnittstellen, IT‑Sicherheit und eine robuste Integration in bestehende Prozesse (z. B. Flottenmanagement, ERP, Gebäudetechnik).</p>
    </section>

    <section>
      <h2>Rechtliches & Datenschutz</h2>
      <h3>Verwendet die Website Cookies?</h3>
      <p>FrisiLogix nutzt nur technisch notwendige Cookies – keine Tracking‑ oder Marketing‑Cookies. Details in der <a href="<?php echo htmlspecialchars($base . '/de/datenschutz.php'); ?>">Datenschutzerklärung</a>.</p>

      <h3>Wo finde ich das Impressum?</h3>
      <p>Im <a href="<?php echo htmlspecialchars($base . '/de/impressum.php'); ?>">Impressum</a> sind alle Pflichtangaben aufgeführt.</p>
    </section>

    <section>
      <h2>Kontakt</h2>
      <h3>Wie ist FrisiLogix am besten erreichbar?</h3>
      <p>Am schnellsten per <a href="#contactModal">Kontaktformular</a> – FrisiLogix meldet sich zeitnah zurück.</p>
    </section>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
