<?php
require_once __DIR__ . '/../includes/counter.php';
$page_title = 'Home';
$suppress_header_cta = true; // Suppress header CTA on hero page to reduce duplication
include_once __DIR__ . '/../includes/header.php';
include_once __DIR__ . '/../includes/content.php';
include_once __DIR__ . '/../includes/i18n.php'; // Ensure i18n.php is included for isMobile()
$content = getContent();
$base = basePath();
?>

<section class="hero" style="position:relative; overflow:hidden;">
  <video class="hero-bg-video" id="heroVideo" autoplay loop muted playsinline preload="auto" aria-hidden="true" tabindex="-1">
    <source src="<?php echo htmlspecialchars($base); ?>/assets/videos/uClean_compact.mp4" type="video/mp4">
    Ihr Browser unterstützt das Video-Tag nicht.
  </video>
  <div>
    <div id="typewriter-container">
      <div id="typewriter-content" style="display:none;">
        <h1><span class="mobile-break-after">Personalsorgen?</span> War gestern.</h1>
        <h2><a class="robot-link" href="#transportroboter">Transportroboter</a></h2>
        <h2><a class="robot-link" href="#lieferroboter">Lieferroboter</a></h2>
        <h2><a class="robot-link" href="#reinigungsroboter">Reinigungsroboter</a></h2>
        <h1>– startklar mit Betreuung aus einer Hand.</h1>
      </div>
      <div id="typed-output" aria-live="polite"></div>
    </div>
    <div class="hero-cta-div">
      <a href="#contactModal" class="hero-cta-btn" id="openContactHero" aria-label="Kontakt aufnehmen">Kontakt aufnehmen<span class="cta-arrow" aria-hidden="true">→</span></a>
    </div>
  </div>
</section>
<div class="scroll-indicator hidden" aria-hidden="true"></div>

<section class="features-wrap" id="leistungen">
  <h2 class="section-heading primary-color-text">Dienstleistungen</h2>
  <div class="features">
    <?php echo renderFeatures(); ?>
  </div>
  <aside class="feature-image" aria-label="Roboter Bild">
    <figure class="feature-image-figure">
      <img loading="lazy"
           src="<?php echo htmlspecialchars($base); ?>/assets/images/ulogdeliver.png"
           alt="uLog Lieferroboter im Lager" />
    </figure>
  </aside>
</section>

<!-- New Roboter section (placeholder) -->
<section id="roboter" class="roboter-section section-grid" aria-label="Roboter">
  <div class="container robots-container">

    <section class="robot-segment robot-segment--transport" aria-labelledby="transportroboter">
      <div class="transport-robot-segment__grid">
        <div class="transport-robot-media" aria-label="Transportroboter Video">
          <video class="transport-robot-video" preload="metadata" muted playsinline loop>
            <source src="<?php echo htmlspecialchars($base); ?>/assets/videos/uLog_Lift.mp4" type="video/mp4">
            Ihr Browser unterstützt das Video-Tag nicht.
          </video>
        </div>
        <div class="transport-robot-text" aria-label="Transportroboter Beschreibung">
          <?php $tr = $content['robots']['transport'] ?? null; ?>
          <h3 id="transportroboter" class="section-heading primary-color-text"><?php echo htmlspecialchars($tr['title'] ?? 'Transportroboter'); ?></h3>
          <?php if (!empty($tr['text']) && is_array($tr['text'])): foreach ($tr['text'] as $p): ?>
            <p><?php echo htmlspecialchars($p); ?></p>
          <?php endforeach; endif; ?>
        </div>
      </div>
    </section>

    <section class="reinigungs-roboter-segment" aria-labelledby="reinigungsroboter">
      <div class="reinigungs-robot-segment__grid">
        <div class="reinigungs-robot-text" aria-label="Reinigungsroboter Beschreibung">
          <?php $cr = $content['robots']['cleaning'] ?? null; ?>
          <h3 id="reinigungsroboter" class="section-heading primary-color-text"><?php echo htmlspecialchars($cr['title'] ?? 'Reinigungsroboter'); ?></h3>
          <?php if (!empty($cr['text']) && is_array($cr['text'])): foreach ($cr['text'] as $p): ?>
            <p><?php echo htmlspecialchars($p); ?></p>
          <?php endforeach; endif; ?>
        </div>
        <div class="reinigungs-robot-media" aria-label="Reinigungsroboter Video">
          <video class="reinigungs-robot-video" preload="metadata" muted playsinline loop>
            <source src="<?php echo htmlspecialchars($base); ?>/assets/videos/uClean_Beetle.mp4" type="video/mp4">
            Ihr Browser unterstützt das Video-Tag nicht.
          </video>
        </div>
      </div>
    </section>

    <section class="liefer-roboter-segment" aria-labelledby="lieferroboter">
      <div class="liefer-robot-segment__grid">
        <div class="liefer-robot-text" aria-label="Lieferroboter Beschreibung">
          <?php $dr = $content['robots']['delivery'] ?? null; ?>
          <h3 id="lieferroboter" class="section-heading primary-color-text"><?php echo htmlspecialchars($dr['title'] ?? 'Lieferroboter'); ?></h3>
          <?php if (!empty($dr['text']) && is_array($dr['text'])): foreach ($dr['text'] as $p): ?>
            <p><?php echo htmlspecialchars($p); ?></p>
          <?php endforeach; endif; ?>
        </div>
        <div class="liefer-robot-media" aria-label="Lieferroboter Bild">
          <img class="liefer-robot-image" src="<?php echo htmlspecialchars($base); ?>/assets/images/uServe.png" alt="Lieferroboter uServe" />
        </div>
      </div>
    </section>
  </div>
</section>

<section id="einsatzbereiche" class="environments-section section-grid" aria-label="Einsatzbereiche">
  <div class="container env-container">
    <h2 class="section-heading primary-color-text">Einsatzbereiche</h2>
    <div class="env-grid">
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-industry env-icon" aria-hidden="true"></i>
            <span class="env-title">Produktionslogistik</span>
          </div>
          <div class="env-back env-details" id="env-details-prod" hidden>
            <?php $envProd = $content['environments']['production'] ?? null; ?>
            <?php if (is_array($envProd) && !empty($envProd)): foreach ($envProd as $p): ?>
              <p><?php echo htmlspecialchars($p); ?></p>
            <?php endforeach; else: ?>
              <p>Inhalt folgt.</p>
            <?php endif; ?>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Details anzeigen" aria-expanded="false" aria-controls="env-details-prod">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-store env-icon" aria-hidden="true"></i>
            <span class="env-title">Retail / Einzelhandel</span>
          </div>
          <div class="env-back env-details" id="env-details-retail" hidden>
            <?php $envRetail = $content['environments']['retail'] ?? null; ?>
            <?php if (is_array($envRetail) && !empty($envRetail)): foreach ($envRetail as $p): ?>
              <p><?php echo htmlspecialchars($p); ?></p>
            <?php endforeach; else: ?>
              <p>Inhalt folgt.</p>
            <?php endif; ?>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Details anzeigen" aria-expanded="false" aria-controls="env-details-retail">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-notes-medical env-icon" aria-hidden="true"></i>
            <span class="env-title">Healthcare / Gesundheitswesen</span>
          </div>
          <div class="env-back env-details" id="env-details-health" hidden>
            <?php $envHealth = $content['environments']['healthcare'] ?? null; ?>
            <?php if (is_array($envHealth) && !empty($envHealth)): foreach ($envHealth as $p): ?>
              <p><?php echo htmlspecialchars($p); ?></p>
            <?php endforeach; else: ?>
              <p>Inhalt folgt.</p>
            <?php endif; ?>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Details anzeigen" aria-expanded="false" aria-controls="env-details-health">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-utensils env-icon" aria-hidden="true"></i>
            <span class="env-title">Gastronomie &amp; Hospitality</span>
          </div>
          <div class="env-back env-details" id="env-details-hosp" hidden>
            <?php $envHosp = $content['environments']['hospitality'] ?? null; ?>
            <?php if (is_array($envHosp) && !empty($envHosp)): foreach ($envHosp as $p): ?>
              <p><?php echo htmlspecialchars($p); ?></p>
            <?php endforeach; else: ?>
              <p>Inhalt folgt.</p>
            <?php endif; ?>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Details anzeigen" aria-expanded="false" aria-controls="env-details-hosp">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
    </div>
  </div>
  
</section>

<?php include_once __DIR__ . '/../includes/footer.php'; ?>
