<?php
$page_title = 'Integration & Inbetriebnahme';
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/content.php';

$content = getContent();
$feature = $content['features'][1]; // Get the specific feature content
?>

<section class="hero" style="background-image: url('/assets/images/integration-hero.jpg');">
  <div class="container">
    <h1><?php echo htmlspecialchars($feature['title']); ?></h1>
    <p>Nahtlose Einbindung mobiler Robotik in Ihre bestehenden Prozesse.</p>
  </div>
</section>

<section class="service-content" style="padding: 4rem 1rem;">
  <div class="container" style="max-width: 800px; margin: auto;">
    <h2>Unsere Vorgehensweise</h2>
    <p><?php echo htmlspecialchars($feature['text']); ?></p>
    <br>
    <h3>Schritt 1: Analyse & Planung</h3>
    <p>Wir analysieren Ihre aktuellen Intralogistikprozesse und identifizieren die besten Einsatzmöglichkeiten für mobile Roboter. Gemeinsam mit Ihnen erstellen wir einen detaillierten Integrationsplan.</p>
    
    <h3>Schritt 2: Systemintegration & Softwareanbindung</h3>
    <p>Unsere Experten installieren die Roboter vor Ort und sorgen für eine reibungslose Anbindung an Ihre Lagerverwaltungs- (WMS) oder Manufacturing-Execution-Systeme (MES).</p>

    <h3>Schritt 3: Inbetriebnahme & Test</h3>
    <p>Nach der Installation führen wir umfassende Tests durch, um sicherzustellen, dass die Roboterflotte effizient und fehlerfrei arbeitet. Wir übergeben Ihnen ein schlüsselfertiges System.</p>

    <div style="margin-top: 3rem; text-align: center;">
        <a href="#contactModal" class="cta-btn" onclick="document.getElementById('contactModal').style.display='flex'; return false;">Jetzt Beratung anfordern</a>
    </div>

  </div>
</section>

<?php include __DIR__ . '/../includes/footer.php'; ?>