<?php
$page_title = 'About';
include __DIR__ . '/../includes/header.php';
include_once __DIR__ . '/../includes/content.php';

$about = getContent('about_me') ?: [];
$title = $about['title'] ?? 'About';
$text  = $about['text']  ?? null;
$base  = basePath();
?>

<section class="content-page container legal-page about-page">
  <?php /* Heading intentionally hidden/removed */ ?>
  <div class="about-content">
    <div class="about-text">
    <?php if (is_string($text) && trim($text) !== ''): ?>
      <?php
        $paras = preg_split('/\R{2,}/u', str_replace("\r\n", "\n", $text));
        foreach ($paras as $p) {
          $p = trim($p);
          if ($p === '') continue;
          echo '<p>' . nl2br(htmlspecialchars($p, ENT_QUOTES, 'UTF-8')) . '</p>';
        }
      ?>
    <?php else: ?>
      <p>This area is prepared and will be filled with content shortly.</p>
    <?php endif; ?>
    </div>
  </div>
</section>

<?php include __DIR__ . '/../includes/footer.php'; ?>
