<?php
$page_title = 'FAQ';
include __DIR__ . '/../includes/header.php';
include_once __DIR__ . '/../includes/i18n.php';
$base = basePath();
?>

<div class="content-page legal-page faq-page">
  <div class="container">
    <h1>FAQ</h1>

    <section>
      <h2>General</h2>
      <h3>What does FrisiLogix do?</h3>
      <p>FrisiLogix provides consulting, integration, and training around mobile robotics (AMR/AGV) – pragmatic and future‑proof. We also sell systems and offer RaaS (Robotics as a Service).</p>

      <h3>Who is it for?</h3>
      <p>For companies looking to automate in‑house transport or cleaning processes – from first concept through integration to ongoing service and maintenance.</p>
    </section>

    <section>
      <h2>Services & Process</h2>
      <h3>What does a typical project look like?</h3>
      <p>Usually three steps: 1) quick scoping, 2) planning/pilot, 3) integration & training. Lean, transparent, with clear milestones.</p>

      

      <h3>How fast can we start?</h3>
      <p>Intro call on short notice. Pilots often within weeks – depending on material availability and on‑site infrastructure.</p>
    </section>

    <section>
      <h2>Costs & Offer</h2>
      <h3>How much does it cost?</h3>
      <p>It depends on the use case, environment, and scope. FrisiLogix provides a non‑binding quote after a short requirements check.</p>

      <h3>Do you visit the site?</h3>
      <p>Yes, where it makes sense. Alternatively, FrisiLogix starts remotely and evaluates the need for an on‑site visit afterward.</p>
    </section>

    <section>
      <h2>Technology & Operations</h2>
      <h3>Do you support after go‑live?</h3>
      <p>Yes. FrisiLogix provides support, training, and on‑going optimization – depending on the agreement.</p>

      <h3>Compatibility & security</h3>
      <p>FrisiLogix ensures clean interfaces, IT security, and robust integration into existing processes (e.g., fleet management, ERP, building tech).</p>
    </section>

    <section>
      <h2>Legal & Privacy</h2>
      <h3>Does the website use cookies?</h3>
      <p>FrisiLogix only uses technically necessary cookies – no tracking or marketing cookies. See our <a href="<?php echo htmlspecialchars($base . '/en/privacy.php'); ?>">Privacy Policy</a> for details.</p>

      <h3>Where is the imprint?</h3>
      <p>All mandatory information is available in the <a href="<?php echo htmlspecialchars($base . '/en/imprint.php'); ?>">Imprint</a>.</p>
    </section>

    <section>
      <h2>Contact</h2>
      <h3>What’s the best way to reach you?</h3>
      <p>The quickest way is via the <a href="#contactModal">contact form</a> – FrisiLogix will get back to you shortly.</p>
    </section>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
