<?php
require_once __DIR__ . '/../includes/counter.php';
$page_title = 'Home';
$suppress_header_cta = true; // Suppress header CTA on hero page
include_once __DIR__ . '/../includes/header.php';
include_once __DIR__ . '/../includes/content.php';
include_once __DIR__ . '/../includes/i18n.php'; // Ensure i18n.php is included for isMobile()
$content = getContent();
$base = basePath();
?>

<section class="hero" style="position:relative; overflow:hidden;">
  <video class="hero-bg-video" id="heroVideo" autoplay loop muted playsinline preload="auto" aria-hidden="true" tabindex="-1">
    <source src="<?php echo htmlspecialchars($base); ?>/assets/videos/uClean_compact.mp4" type="video/mp4">
    Your browser does not support the video tag.
  </video>
  <div>
    <div id="typewriter-container">
      <div id="typewriter-content" style="display:none;">
        <h1>Staffing worries? That's yesterday.</h1>
        <h2><a class="robot-link" href="#seg-transport-en">Transport robots</a></h2>
        <h2><a class="robot-link" href="#seg-delivery-en">Delivery robots</a></h2>
        <h2><a class="robot-link" href="#seg-cleaning-en">Cleaning robots</a></h2>
        <h1>– ready to go with all-in-one support.</h1>
      </div>
      <div id="typed-output" aria-live="polite"></div>
    </div>
    <div class="hero-cta-div">
      <a href="#contactModal" class="hero-cta-btn" id="openContactHero" aria-label="Get in touch">Get in touch<span class="cta-arrow" aria-hidden="true">→</span></a>
    </div>
  </div>
</section>
<div class="scroll-indicator hidden" aria-hidden="true"></div>

<section class="features-wrap" id="leistungen">
  <h2 class="section-heading primary-color-text">Services</h2>
  <div class="features">
    <?php echo renderFeatures(); ?>
  </div>
  <aside class="feature-image" aria-label="Robotics image">
    <figure class="feature-image-figure">
      <img loading="lazy"
           src="<?php echo htmlspecialchars($base); ?>/assets/images/ulogdeliver.png"
           alt="uLog delivery robot in warehouse" />
    </figure>
  </aside>
</section>

<!-- New Robots section (placeholder) -->
<section id="roboter" class="roboter-section section-grid" aria-label="Robots">
  <div class="container robots-container">

    <section class="robot-segment robot-segment--transport" aria-labelledby="seg-transport-en">
      <div class="transport-robot-segment__grid">
        <div class="transport-robot-media" aria-label="Transport robots video">
          <video class="transport-robot-video" preload="metadata" muted playsinline loop>
            <source src="<?php echo htmlspecialchars($base); ?>/assets/videos/uLog_Lift.mp4" type="video/mp4">
            Your browser does not support the video tag.
          </video>
        </div>
        <div class="transport-robot-text" aria-label="Transport robots description">
          <?php $tr = $content['robots']['transport'] ?? null; ?>
          <h3 id="seg-transport-en" class="section-heading primary-color-text"><?php echo htmlspecialchars($tr['title'] ?? 'Transport robots'); ?></h3>
          <?php if (!empty($tr['text']) && is_array($tr['text'])): foreach ($tr['text'] as $p): ?>
            <p><?php echo htmlspecialchars($p); ?></p>
          <?php endforeach; endif; ?>
        </div>
      </div>
    </section>

    <section class="reinigungs-roboter-segment" aria-labelledby="seg-cleaning-en">
      <div class="reinigungs-robot-segment__grid">
        <div class="reinigungs-robot-text" aria-label="Cleaning robots description">
          <?php $cr = $content['robots']['cleaning'] ?? null; ?>
          <h3 id="seg-cleaning-en" class="section-heading primary-color-text"><?php echo htmlspecialchars($cr['title'] ?? 'Cleaning robots'); ?></h3>
          <?php if (!empty($cr['text']) && is_array($cr['text'])): foreach ($cr['text'] as $p): ?>
            <p><?php echo htmlspecialchars($p); ?></p>
          <?php endforeach; endif; ?>
        </div>
        <div class="reinigungs-robot-media" aria-label="Cleaning robots video">
          <video class="reinigungs-robot-video" preload="metadata" muted playsinline loop>
            <source src="<?php echo htmlspecialchars($base); ?>/assets/videos/uClean_Beetle.mp4" type="video/mp4">
            Your browser does not support the video tag.
          </video>
        </div>
      </div>
    </section>

    <section class="liefer-roboter-segment" aria-labelledby="seg-delivery-en">
      <div class="liefer-robot-segment__grid">
        <div class="liefer-robot-media" aria-label="Delivery robots image">
          <img class="liefer-robot-image" src="<?php echo htmlspecialchars($base); ?>/assets/images/uServe.png" alt="Delivery robot uServe" />
        </div>
        <div class="liefer-robot-text" aria-label="Delivery robots description">
          <?php $dr = $content['robots']['delivery'] ?? null; ?>
          <h3 id="seg-delivery-en" class="section-heading primary-color-text"><?php echo htmlspecialchars($dr['title'] ?? 'Delivery robots'); ?></h3>
          <?php if (!empty($dr['text']) && is_array($dr['text'])): foreach ($dr['text'] as $p): ?>
            <p><?php echo htmlspecialchars($p); ?></p>
          <?php endforeach; endif; ?>
        </div>
      </div>
    </section>
  </div>
</section>

<section id="industries" class="environments-section section-grid" aria-label="Industries">
  <div class="container env-container">
    <h2 class="section-heading primary-color-text">Industries</h2>
    <div class="env-grid">
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-industry env-icon" aria-hidden="true"></i>
            <span class="env-title">Manufacturing logistics</span>
          </div>
          <div class="env-back env-details" id="env-details-prod" hidden>
            <p>Autonomous transport robots connect workstations, buffers, and warehouses just-in-time. They reduce manual handling, stabilize takt, and increase throughput without rigid conveyor systems.</p>
            <p>Use cases: line supply and disposal, finished goods transport, inter-process transfers, shuttle between production and warehouse, Kanban replenishment.</p>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Show details" aria-expanded="false" aria-controls="env-details-prod">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-store env-icon" aria-hidden="true"></i>
            <span class="env-title">Retail</span>
          </div>
          <div class="env-back env-details" id="env-details-retail" hidden>
            <p>AMRs move goods from back-of-house to sales floor, handle click-and-collect staging, and support night replenishment. Cleaning robots keep aisles safe and presentable during opening hours.</p>
            <p>Use cases: shelf replenishment support, stock transfers, e‑commerce order staging, floor cleaning in high-traffic areas.</p>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Show details" aria-expanded="false" aria-controls="env-details-retail">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-notes-medical env-icon" aria-hidden="true"></i>
            <span class="env-title">Healthcare</span>
          </div>
          <div class="env-back env-details" id="env-details-health" hidden>
            <p>Delivery robots transport meals, linens, and supplies contactlessly between floors and wards. Cleaning robots improve hygiene with consistent, documented results — relieving staff for patient care.</p>
            <p>Use cases: meal distribution, pharmacy runs, linen logistics, waste removal, corridor and lobby cleaning.</p>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Show details" aria-expanded="false" aria-controls="env-details-health">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
      <div class="env-card">
        <div class="env-inner">
          <div class="env-front">
            <i class="fa-solid fa-utensils env-icon" aria-hidden="true"></i>
            <span class="env-title">Hospitality &amp; Food Service</span>
          </div>
          <div class="env-back env-details" id="env-details-hosp" hidden>
            <p>Service robots support front-of-house teams with reliable delivery from kitchen to tables and rooms. Cleaning robots ensure consistently clean floors in guest areas and back-of-house.</p>
            <p>Use cases: table delivery, bussing support, room-service logistics, kitchen‑to‑station shuttles, dining area cleaning.</p>
          </div>
        </div>
        <button class="env-toggle" type="button" aria-label="Show details" aria-expanded="false" aria-controls="env-details-hosp">
          <i class="fa-solid fa-chevron-down" aria-hidden="true"></i>
        </button>
      </div>
    </div>
  </div>
  
</section>

<?php include_once __DIR__ . '/../includes/footer.php'; ?>
