<?php
$page_title = 'Integration & Commissioning';
include __DIR__ . '/../includes/header.php';
include __DIR__ . '/../includes/content.php';

$content = getContent();
$feature = $content['features'][1]; // Get the specific feature content
?>

<section class="hero" style="background-image: url('/assets/images/integration-hero.jpg');">
  <div class="container">
    <h1><?php echo htmlspecialchars($feature['title']); ?></h1>
    <p>Seamless integration of mobile robotics into your existing processes.</p>
  </div>
</section>

<section class="service-content" style="padding: 4rem 1rem;">
  <div class="container" style="max-width: 800px; margin: auto;">
    <h2>Our Approach</h2>
    <p><?php echo htmlspecialchars($feature['text']); ?></p>
    <br>
    <h3>Step 1: Analysis & Planning</h3>
    <p>We analyze your current intralogistics processes and identify the best application possibilities for mobile robots. Together with you, we create a detailed integration plan.</p>
    
    <h3>Step 2: System Integration & Software Connection</h3>
    <p>Our experts install the robots on-site and ensure a smooth connection to your warehouse management (WMS) or manufacturing execution systems (MES).</p>

    <h3>Step 3: Commissioning & Testing</h3>
    <p>After installation, we carry out comprehensive tests to ensure that the robot fleet works efficiently and without errors. We hand over a turnkey system to you.</p>

    <div style="margin-top: 3rem; text-align: center;">
        <a href="#contactModal" class="cta-btn" onclick="document.getElementById('contactModal').style.display='flex'; return false;">Request a consultation now</a>
    </div>

  </div>
</section>

<?php include __DIR__ . '/../includes/footer.php'; ?>