<?php
$page_title = 'Privacy Policy';
include __DIR__ . '/../includes/header.php';
?>

<div class="content-page legal-page">
  <div class="container">
    <h1>Privacy Policy</h1>

    <section>
      <h2>1. Data protection at a glance</h2>
      <h3>General information</h3>
      <p>
        The following notes provide a simple overview of what happens to your personal data when you visit this website. Personal data is any data with which you can be personally identified.
      </p>
    </section>

    <section>
      <h2>2. Data collection on this website</h2>
      <h3>Who is responsible for data collection?</h3>
      <p>
        Data processing on this website is carried out by the website operator. You can find the operator's contact details in the “Information about the responsible party” section of this privacy policy.
      </p>
      <h3>How do we collect your data?</h3>
      <p>
        Some data is collected when you provide it to us. This can be data you enter in a contact form, for example. Other data is collected automatically or after your consent when you visit the website by our IT systems. This is primarily technical data (e.g. internet browser, operating system, or time of page access).
      </p>
      <h3>What do we use your data for?</h3>
      <p>
        Part of the data is collected to ensure error-free provision of the website. Other data can be used to analyze your user behavior.
      </p>
    </section>

    <section>
      <h2>3. Hosting</h2>
      <p>
        We host our website with a professional hosting provider. The privacy policy of the hosting provider applies to the data processed by the hosting provider.
      </p>
    </section>

    <section>
      <h2>4. General notes and mandatory information</h2>
      <h3>Data protection</h3>
      <p>
        The operators of these pages take the protection of your personal data very seriously. We treat your personal data confidentially and in accordance with statutory data protection regulations and this privacy policy.
      </p>
      <h3>Information about the responsible party</h3>
      <p>The responsible party for data processing on this website is:</p>
      <p>
        Alexander Friesen<br>
        Goethestr. 56<br>
        58540 Meinerzhagen<br>
        Germany<br>
        E-mail: info@frisilogix.de<br>
        Tel. +49 2354 9449391
      </p>
    </section>

    <section>
      <h2>5. Data collection on this website</h2>
      <h3>Cookies</h3>
      <p>We only use technically necessary cookies, e.g., to store your settings (such as form security features). We do not use tracking or marketing cookies. The legal basis for necessary cookies is Section 25(2) No. 2 TTDSG and Art. 6(1)(f) GDPR (legitimate interest in secure and functional website operation).</p>
      <h3>Server log files</h3>
      <p>
        Our hosting provider (all‑inkl.com) automatically collects and stores information in server log files that your browser automatically transmits to us, in particular:
      </p>
      <ul>
        <li>browser type and version</li>
        <li>operating system used</li>
        <li>referrer URL</li>
        <li>hostname of the accessing device</li>
        <li>date and time of the request</li>
        <li>IP address of the requesting device</li>
      </ul>
      <p>
        Processing is carried out to deliver the website, ensure stability and security (e.g., detecting abuse/attacks), and troubleshoot issues (Art. 6(1)(f) GDPR). This data is not merged with other data sources. Log files are deleted on a regular basis; longer retention may occur on a case‑by‑case basis to preserve evidence in security incidents. Processing is performed on our behalf by our hosting provider (processing under Art. 28 GDPR).
      </p>
    </section>

    <section>
      <h2>6. Your rights</h2>
      <p>
        You have the right to access, rectification, erasure, and restriction of processing of personal data. You also have the right to lodge a complaint with the competent supervisory authority.
      </p>
    </section>

    <section>
      <h2>7. Social networks (LinkedIn)</h2>
      <p>
        We maintain an online presence on LinkedIn. When you visit our LinkedIn page, LinkedIn (LinkedIn Ireland Unlimited Company, Wilton Plaza, Wilton Place, Dublin 2, Ireland) processes personal data under its own responsibility according to its privacy policy: <a href=\"https://www.linkedin.com/legal/privacy-policy\" target=\"_blank\" rel=\"noopener\">www.linkedin.com/legal/privacy-policy</a>.
      </p>
      <p>
        Visiting our website does not load LinkedIn scripts or set LinkedIn cookies; only when you click the LinkedIn link in the footer you will leave our website and be redirected to LinkedIn.
      </p>
    </section>

    <section>
      <h2>8. Contact</h2>
      <p>
        If you have any questions about the collection, processing, or use of your personal data, please contact: info@frisilogix.de
      </p>
    </section>
  </div>
</div>

<?php include __DIR__ . '/../includes/footer.php'; ?>
