<?php
require_once __DIR__ . '/i18n.php';

function getContent($key = null) {
    static $content = null;

    if ($content === null) {
        $content = getLocalizedContent();
    }

    if ($key === null) {
        return $content;
    }

    $keys = explode('.', $key);
    $value = $content;

    foreach ($keys as $k) {
        if (isset($value[$k])) {
            $value = $value[$k];
        } else {
            return null;
        }
    }

    return $value;
}

function renderFeatures() {
    $features = getContent('features');
    if (!$features) return '';

    $html = '';
    $iconMap = [
        // Use robot face icon for mobile robot integration cards
        'Integration autonomer mobiler Roboter' => 'fa-solid fa-robot',
        'Service & Support' => 'fa-solid fa-headset',
        'Beratung, Training & Demo' => 'fa-solid fa-lightbulb',
        'Robotics-as-a-Service (RaaS)' => 'fa-solid fa-cloud',
        'Verkauf mobiler Robotik' => 'fa-solid fa-cart-shopping',
        // Add English mappings if needed, or handle dynamically
        // English titles from content.en.json
        'Mobile Robot Integration' => 'fa-solid fa-robot',
        'Autonomous Mobile Robot Integration' => 'fa-solid fa-robot',
        'Service & Support' => 'fa-solid fa-headset',
        'Consulting, Training & Demo' => 'fa-solid fa-lightbulb',
        'Robotics-as-a-Service (RaaS)' => 'fa-solid fa-cloud',
        'Sales of mobile robotics' => 'fa-solid fa-cart-shopping',
    ];

    // Helper to create a slug/id from a title (supports DE/EN)
    $slugify = function($str) {
        $s = $str ?? '';
        $replacements = [ 'ä'=>'ae','ö'=>'oe','ü'=>'ue','Ä'=>'Ae','Ö'=>'Oe','Ü'=>'Ue','ß'=>'ss' ];
        $s = strtr($s, $replacements);
        if (function_exists('mb_strtolower')) { $s = mb_strtolower($s, 'UTF-8'); } else { $s = strtolower($s); }
        $s = preg_replace('~[^a-z0-9]+~u', '-', $s);
        $s = trim($s, '-');
        return $s;
    };

    foreach ($features as $feature) {
        $title = $feature['title'] ?? '';
        $text = $feature['text'] ?? ($feature['description'] ?? '');
        $iconClass = $iconMap[$title] ?? 'fa-solid fa-circle-info'; // Default icon if no match
        $id = 'leistungen-' . $slugify($title);

        $html .= '<div class="feature" id="' . htmlspecialchars($id) . '">';
        $html .= '<h3><i class="' . htmlspecialchars($iconClass) . ' feature-icon"></i> <span class="feat-title">' . htmlspecialchars($title) . '</span><span class="chevron" aria-hidden="true"></span></h3>';
        $html .= '<p>' . htmlspecialchars($text) . '</p>';
        $html .= '</div>';
    }

    return $html;
}
?>
