<?php
// Shared visit counter: increments once per PHP session.
if (session_status() === PHP_SESSION_NONE) {
    session_start();
}

if (!isset($_SESSION['visited_landing_page'])) {
    $counterFile = dirname(__DIR__) . '/counter.json';
    if (file_exists($counterFile)) {
        $data = json_decode(@file_get_contents($counterFile), true);
        if (!is_array($data)) { $data = []; }
        $data['visits'] = ($data['visits'] ?? 0) + 1;
        $json = json_encode($data, JSON_PRETTY_PRINT);
        $res = @file_put_contents($counterFile, $json);
        if ($res === false) {
            error_log('counter: failed to write counter.json');
        }
    } else {
        error_log('counter: counter.json not found');
    }
    $_SESSION['visited_landing_page'] = true;
}

