</main>
<?php // i18n + base-path available for the entire footer/modal section ?>
<?php include_once __DIR__ . '/i18n.php'; $langAttr = detectLanguage(); $base = basePath(); ?>

<footer class="footer" role="contentinfo">
  <div class="footer__grid">
    <div class="footer__left">
      <p class="footer__copy">
        &copy; <time datetime="<?php echo date('Y'); ?>"><?php echo date('Y'); ?></time> Alexander Friesen
      </p>
      <div class="footer__social">
        <a href="https://www.linkedin.com/in/alexander-friesen-598721273/" target="_blank" rel="noopener noreferrer me" aria-label="LinkedIn">
          <svg viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg" aria-hidden="true" focusable="false">
            <path fill="currentColor" d="M4.98 3.5C4.98 4.88 3.86 6 2.5 6S0 4.88 0 3.5 1.12 1 2.5 1s2.48 1.12 2.48 2.5zM0 8h5v16H0V8zm7.5 0h4.7v2.2h.1c.7-1.3 2.4-2.7 4.9-2.7 5.2 0 6.2 3.4 6.2 7.8V24h-5V16.2c0-1.9 0-4.3-2.6-4.3-2.6 0-3 2-3 4.1V24h-5V8z"/>
          </svg>
        </a>
      </div>
    </div>
    <?php $currentPath = relativePathWithoutLang(); $legalLabel = ($langAttr==='en' ? 'Legal' : 'Rechtliches'); ?>
    <nav class="footer__nav" aria-label="<?php echo htmlspecialchars($legalLabel); ?>">
      <ul class="footer__list">
        <li class="footer__item">
          <a class="<?php echo ($currentPath === '/impressum.php' || $currentPath === '/imprint.php') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars($base . '/' . ($langAttr==='en' ? 'en/imprint.php' : 'de/impressum.php')); ?>"><?php echo $langAttr==='en' ? 'Imprint' : 'Impressum'; ?></a>
        </li>
        <li class="footer__item">
          <a class="<?php echo ($currentPath === '/datenschutz.php' || $currentPath === '/privacy.php') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars($base . '/' . ($langAttr==='en' ? 'en/privacy.php' : 'de/datenschutz.php')); ?>"><?php echo $langAttr==='en' ? 'Privacy Policy' : 'Datenschutz'; ?></a>
        </li>
        <li class="footer__item">
          <a class="<?php echo ($currentPath === '/ueber.php' || $currentPath === '/about.php') ? 'active' : ''; ?>" href="<?php echo htmlspecialchars($base . '/' . ($langAttr==='en' ? 'en/about.php' : 'de/ueber.php')); ?>"><?php echo $langAttr==='en' ? 'About' : 'Über'; ?></a>
        </li>
      </ul>
    </nav>
    <div class="footer__right">
      <a href="#" id="back-to-top" class="footer__up-button">
        <i class="fas fa-arrow-up"></i>
      </a>
    </div>
  </div>
</footer>

<?php // Floating contact button removed ?>

<?php // Contact modal markup ?>
<div id="contactModal" class="contact-modal" style="display:none" role="dialog" aria-modal="true" aria-labelledby="contactTitle">
  <div class="contact-modal-content">
    <button id="closeContact" class="contact-modal-close" aria-label="<?php echo $langAttr==='en' ? 'Close contact form' : 'Kontaktformular schließen'; ?>">&times;</button>
    <?php include_once __DIR__ . '/content.php'; $ui = getContent('_ui'); $phoneMobile = (string)($ui['phone_mobile'] ?? ''); ?>
    <h2 id="contactTitle"><?php echo htmlspecialchars($ui['contact_title'] ?? ($langAttr === 'en' ? 'Get in touch' : 'Kontaktanfrage')); ?></h2>
    <form id="contact-form" action="<?php echo htmlspecialchars($base); ?>/send_mail.php" method="post" novalidate>
      <div class="form-group">
        <input type="text" name="name" placeholder="<?php echo $langAttr==='en' ? 'Your name' : 'Ihr Name'; ?>" required />
        <input type="email" name="email" placeholder="E-mail" required />
      </div>
      <div class="form-group">
        <input type="text" name="subject" placeholder="<?php echo $langAttr==='en' ? 'Subject' : 'Betreff'; ?>" required />
      </div>
      <div class="form-group">
        <textarea name="message" rows="5" placeholder="<?php echo $langAttr==='en' ? 'Your message' : 'Ihre Nachricht'; ?>" required></textarea>
      </div>
      <p class="privacy-notice">
        <?php if ($langAttr==='en'): ?>
          We process your data to handle your request (Art. 6(1)(b) GDPR). More details in our <a href="<?php echo htmlspecialchars($base . '/en/privacy.php'); ?>" target="_blank" rel="noopener">Privacy Policy</a>.
        <?php else: ?>
          Wir verarbeiten Ihre Daten zur Bearbeitung Ihrer Anfrage (Art. 6 Abs. 1 lit. b DSGVO). Details in unserer <a href="<?php echo htmlspecialchars($base . '/de/datenschutz.php'); ?>" target="_blank" rel="noopener">Datenschutzerklärung</a>.
        <?php endif; ?>
      </p>
      <div class="form-group-footer">
        <?php if (!empty($phoneMobile)): ?>
        <div class="callout-phone">
          <span class="callout-label"><?php echo $langAttr==='en' ? 'Call directly:' : 'Direkt anrufen:'; ?></span>
          <a class="callout-link" href="tel:<?php echo htmlspecialchars(preg_replace('/\s+/', '', $phoneMobile)); ?>" aria-label="<?php echo $langAttr==='en' ? 'Call' : 'Anrufen'; ?> <?php echo htmlspecialchars($phoneMobile); ?>">
            <span class="callout-icon" aria-hidden="true">📞</span>
            <span class="callout-number"><?php echo htmlspecialchars($phoneMobile); ?></span>
          </a>
        </div>
        <?php endif; ?>
        <button type="submit" class="cta-btn"><?php echo $langAttr==='en' ? 'Send request' : 'Anfrage senden'; ?></button>
      </div>
      <input type="hidden" name="csrf_token" id="csrf_token" value="">
      <input type="text" name="website" id="contact_website" value="" autocomplete="off" tabindex="-1" aria-hidden="true" style="position:absolute;left:-9999px;opacity:0;height:0;width:0;" />
      <div id="form-status" role="status" aria-live="polite"></div>
    </form>
  </div>
</div>

<?php // Mobile sticky call bar (appears after first scroll). Hidden if no phone number is configured. ?>
<?php if (!empty($phoneMobile)): ?>
<div id="callBar" class="call-bar" role="region" aria-label="<?php echo $langAttr==='en' ? 'Quick call bar' : 'Schnellwahl-Leiste'; ?>" style="display:none;">
  <a class="call-bar-link" href="tel:<?php echo htmlspecialchars(preg_replace('/\s+/', '', $phoneMobile)); ?>" aria-label="<?php echo $langAttr==='en' ? 'Call' : 'Anrufen'; ?> <?php echo htmlspecialchars($phoneMobile); ?>">
    <span class="call-bar-icon" aria-hidden="true">📞</span>
    <span class="call-bar-text"><?php echo htmlspecialchars($phoneMobile); ?></span>
  </a>
  <button class="call-bar-close" type="button" aria-label="<?php echo $langAttr==='en' ? 'Hide call bar' : 'Leiste ausblenden'; ?>">&times;</button>
  </div>
<?php endif; ?>

<script type="application/ld+json">
{
  "@context": "https://schema.org",
  "@type": "LocalBusiness",
  "name": "FrisiLogix",
  "image": "https://www.frisilogix.de/assets/images/logo.png",
  "url": "https://www.frisilogix.de",
  "telephone": "+4923549449391",
  "email": "info@frisilogix.de",
  "address": {
    "@type": "PostalAddress",
    "streetAddress": "Goethestr. 56",
    "addressLocality": "Meinerzhagen",
    "postalCode": "58540",
    "addressCountry": "DE"
  },
  "description": "Ihr Partner für Integration, Beratung und Schulung von mobilen Robotern (AMR & AGV) – schnell und zukunftssicher.",
  "founder": {
    "@type": "Person",
    "name": "Alexander Friesen"
  }
}
</script>

<?php // No cookie banner needed while only necessary cookies are used ?>

<script type="module" src="<?php echo htmlspecialchars($base); ?>/js/main.js?v=dev-3"></script>
</body>
</html>
