<!DOCTYPE html>
<?php include_once __DIR__ . '/i18n.php'; $langAttr = detectLanguage(); $base = basePath(); ?>
<html lang="<?php echo htmlspecialchars($langAttr); ?>">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FrisiLogix - Ihr mobile Robotik Partner & Dienstleister</title>
    
    <meta name="description" content="FrisiLogix: Beratung, Integration & Schulung für mobile Roboter (AMR/AGV) in Intralogistik & Automation.">
    <meta name="keywords" content="Mobile Robotik, Automation, AMR, AGV, Intralogistik, Alexander Friesen, FrisiLogix, Roboter Integration">
    <?php
      $scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https://' : 'http://';
      $host = $_SERVER['HTTP_HOST'] ?? 'localhost';
      $reqPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
      $canonical = $scheme . $host . $reqPath;
    ?>
    <link rel="canonical" href="<?php echo htmlspecialchars($canonical); ?>" />
    <?php
      // Add hreflang alternate links for DE/EN
      $pathNoLang = relativePathWithoutLang();
      echo hreflangLinks($langAttr, $pathNoLang);
    ?>
    
    <meta property="og:type" content="website">
    <meta property="og:url" content="<?php echo htmlspecialchars($canonical); ?>">
    <meta property="og:title" content="<?php echo isset($page_title) ? $page_title . ' | FrisiLogix' : 'FrisiLogix | Mobile Robotik & Automation'; ?>">
    <meta property="og:description" content="FrisiLogix: Beratung, Integration & Schulung für mobile Roboter (AMR/AGV) in Intralogistik & Automation.">
    <meta property="og:image" content="https://www.frisilogix.de/assets/images/social-preview.jpg"> 
    
    <meta property="twitter:card" content="summary_large_image">
    <meta property="twitter:url" content="<?php echo htmlspecialchars($canonical); ?>">
    
    <meta property="twitter:title" content="<?php echo isset($page_title) ? $page_title . ' | FrisiLogix' : 'FrisiLogix | Mobile Robotik & Automation'; ?>">
    <meta property="twitter:description" content="FrisiLogix: Beratung, Integration & Schulung für mobile Roboter (AMR/AGV) in Intralogistik & Automation.">
    <meta property="twitter:image" content="https://www.frisilogix.de/assets/images/social-preview.jpg">

    <link rel="stylesheet" href="<?php echo htmlspecialchars($base); ?>/css/fonts.css?v=dev-1">
    <link rel="stylesheet" href="<?php echo htmlspecialchars($base); ?>/assets/vendor/fontawesome/css/all.min.css">
    <link rel="stylesheet" href="<?php echo htmlspecialchars($base); ?>/css/base.css?v=dev-2">
    <link rel="stylesheet" href="<?php echo htmlspecialchars($base); ?>/css/layout.css?v=dev-2">
    <link rel="stylesheet" href="<?php echo htmlspecialchars($base); ?>/css/components.css?v=dev-3">
    <!-- cookie-banner.css removed: no consent banner while no tracking is used -->
    <link rel="icon" href="<?php echo htmlspecialchars($base); ?>/assets/images/favicon.png" type="image/png">
</head>
<body>
    <header>
        <div class="brand">
            <h1><a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/'); ?>">FrisiLogix</a></h1>
            <?php include_once __DIR__ . '/content.php'; $ui = getContent('_ui'); ?>
            <div class="tagline" aria-hidden="false">
                <span class="tagline-part tagline-main"><?php echo htmlspecialchars($ui['slogan_main']); ?></span>
                <span class="tagline-part tagline-smarter"><?php echo htmlspecialchars($ui['slogan_smarter']); ?></span>
            </div>
        </div>
        <nav>
            <?php $ui = getContent('_ui'); ?>
            <?php 
              $robotsBase = $base . '/' . $langAttr . '/#roboter';
              if ($langAttr === 'en') {
                $seg1 = '#seg-transport-en';
                // Swap order: Cleaning before Delivery
                $seg2 = '#seg-cleaning-en';
                $seg3 = '#seg-delivery-en';
              } else {
                $seg1 = '#transportroboter';
                // Swap order: Reinigungsroboter before Lieferroboter
                $seg2 = '#reinigungsroboter';
                $seg3 = '#lieferroboter';
              }
            ?>
            
                <div class="nav-dropdown">
                  <a href="<?php echo htmlspecialchars($robotsBase); ?>" class="nav-link">
                      <span><?php echo htmlspecialchars($ui['robots']); ?></span>
                      <span class="nav-plus">+</span>
                  </a>
                  <div class="dropdown-content">
                    <a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/' . $seg1); ?>"><?php echo $langAttr==='en' ? 'Transport robots' : 'Transportroboter'; ?></a>
                    <a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/' . $seg2); ?>"><?php echo $langAttr==='en' ? 'Cleaning robots' : 'Reinigungsroboter'; ?></a>
                    <a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/' . $seg3); ?>"><?php echo $langAttr==='en' ? 'Delivery robots' : 'Lieferroboter'; ?></a>
                  </div>
                </div>
                <div class="nav-dropdown">
                    <a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/#leistungen'); ?>" class="nav-link">
                        <span><?php echo htmlspecialchars($ui['services']); ?></span>
                        <span class="nav-plus">+</span>
                    </a>
                    <div class="dropdown-content">
                      <?php 
                        $features = getContent('features') ?: [];
                        // Slugify helper (same logic as in renderFeatures)
                        $slugify = function($str){
                            $s = $str ?? '';
                            $repl = ['ä'=>'ae','ö'=>'oe','ü'=>'ue','Ä'=>'Ae','Ö'=>'Oe','Ü'=>'Ue','ß'=>'ss'];
                            $s = strtr($s, $repl);
                            $s = function_exists('mb_strtolower') ? mb_strtolower($s,'UTF-8') : strtolower($s);
                            $s = preg_replace('~[^a-z0-9]+~u','-',$s);
                            $s = trim($s,'-');
                            return $s;
                        };
                        foreach ($features as $f) {
                            $title = $f['title'] ?? '';
                            if (!$title) continue;
                            $id = 'leistungen-' . $slugify($title);
                            $href = $base . '/' . $langAttr . '/#' . $id;
                            echo '<a href="' . htmlspecialchars($href) . '">'. htmlspecialchars($title) . '</a>' . "\n";
                        }
                      ?>
                    </div>
                </div>
                <?php $envAnchor = $langAttr==='en' ? '#industries' : '#einsatzbereiche'; ?>
                <a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/' . $envAnchor); ?>" class="nav-link">
                    <span><?php echo htmlspecialchars($ui['environments']); ?></span>
                    <span class="nav-plus">+</span>
                </a>
                
                <a href="<?php echo htmlspecialchars($base . '/' . $langAttr . '/' . ($langAttr === 'en' ? 'about.php' : 'ueber.php')); ?>" class="nav-link">
                    <span><?php echo htmlspecialchars($ui['about']); ?></span>
                    <span class="nav-plus">+</span>
                </a>
                <?php // Mobile-only language switch inside the overlay menu ?>
                <?php $swm = switchUrls(); $deUrlM = $swm['de']; $enUrlM = $swm['en']; ?>
                <div class="nav-lang-mobile lang-switch" aria-label="Language switcher" role="navigation">
                  <a href="<?php echo htmlspecialchars($deUrlM); ?>" aria-label="Deutsch" class="<?php if ($langAttr === 'de') echo 'active'; ?>">DE</a>
                  <span class="sep" aria-hidden="true">|</span>
                  <a href="<?php echo htmlspecialchars($enUrlM); ?>" aria-label="English" class="<?php if ($langAttr === 'en') echo 'active'; ?>">EN</a>
                </div>
                <!-- Mobile contact button inside overlay menu (always present; only visible when menu is open) -->
                <?php
                  // Use the contact label from the _ui content, with a fallback
                  $contactLabel = $ui['contact'] ?? (($langAttr === 'en') ? 'Contact' : 'Kontakt');
                  // Check if current page is impressum or datenschutz in German
                  $currentPagePath = relativePathWithoutLang();
                  if ($langAttr === 'de' && ($currentPagePath === '/impressum.php' || $currentPagePath === '/datenschutz.php')) {
                      $contactLabel = 'Kontakt';
                  }
                ?>
                <a href="#contactModal" class="cta-btn mobile-contact-btn" role="button">
                  <?php echo htmlspecialchars($contactLabel); ?>
                </a>
            
        </nav>
        <div class="header-right">
          <button class="hamburger" id="hamburger" aria-label="<?php echo ($langAttr === 'en') ? 'Open menu' : 'Menü öffnen'; ?>" aria-expanded="false" type="button">
              <span class="bar"></span>
              <span class="bar"></span>
          </button>
          <?php $btnLabel = ($langAttr === 'en') ? 'Contact' : 'Kontakt'; ?>
          <button class="cta-btn header-contact-btn" onclick="document.getElementById('contactModal').style.display='flex'; return false;">
              <?php echo htmlspecialchars($btnLabel); ?>
          </button>
          <?php $sw = switchUrls(); $deUrl = $sw['de']; $enUrl = $sw['en']; ?>
          <span class="lang-switch" role="navigation" aria-label="Language switcher">
              <a href="<?php echo htmlspecialchars($deUrl); ?>" aria-label="Deutsch" class="<?php if ($langAttr === 'de') echo 'active'; ?>">DE</a>
              <span class="sep" aria-hidden="true">|</span>
              <a href="<?php echo htmlspecialchars($enUrl); ?>" aria-label="English" class="<?php if ($langAttr === 'en') echo 'active'; ?>">EN</a>
          </span>
        </div>
    </header>
    <main>
