<?php
// Counter logic (shared)
require_once __DIR__ . '/includes/counter.php';

// Root entry: redirect once to /de/ or /en/
require_once __DIR__ . '/includes/i18n.php';
$lang = detectLanguage();
$base = basePath();
$targetPath = rtrim($base, '/') . '/' . $lang . '/';
$scheme = (!empty($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on') ? 'https://' : 'http://';
$host = $_SERVER['HTTP_HOST'] ?? '';
$target = $scheme . $host . $targetPath;
// Avoid loops; normalize request path
$uriPath = parse_url($_SERVER['REQUEST_URI'] ?? '/', PHP_URL_PATH);
$baseNoSlash = rtrim($base, '/');
if (
    $uriPath === '/' ||
    $uriPath === '/index.php' ||
    $uriPath === $baseNoSlash ||
    $uriPath === $baseNoSlash . '/' ||
    $uriPath === $baseNoSlash . '/index.php'
) {
    header('Location: ' . $target, true, 302);
    exit;
}
// Fallback: show simple links
?><!DOCTYPE html>
<html><head><meta charset="utf-8"><title>Redirecting…</title></head>
<body>
<p>Redirecting to <a href="<?php echo htmlspecialchars($target); ?>"><?php echo htmlspecialchars($target); ?></a></p>
</body></html>
