// js/banner.js

export function initBanner() {
  (function initBannerVideoControl() {
    const banner = document.querySelector('.feature-banner');
    if (!banner) return;
    const vids = banner.querySelectorAll('video');
    if (!vids.length) return;
    const obs = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        const v = entry.target;
        if (entry.isIntersecting) {
          const p = v.play();
          if (p && p.catch) p.catch(() => {});
        } else {
          v.pause();
        }
      });
    }, {
      threshold: 0.5
    });
    vids.forEach(v => {
      try {
        v.pause();
      } catch (e) {}
      obs.observe(v);
    });
  })();

  // Autoplay/pause Transportroboter video when section enters/leaves viewport
  (function initSectionVideosAutoPlay() {
    const videos = document.querySelectorAll('.transport-robot-video, .reinigungs-robot-video, .liefer-robot-video');
    if (!videos.length) return;
    const io = new IntersectionObserver((entries) => {
      entries.forEach(entry => {
        const v = entry.target.querySelector('video') || entry.target;
        if (!(v instanceof HTMLVideoElement)) return;
        if (entry.isIntersecting) {
          v.muted = true;
          v.loop = true;
          const p = v.play();
          if (p && p.catch) p.catch(() => {});
        } else {
          v.pause();
        }
      });
    }, { threshold: 0.35 });
    videos.forEach(v => io.observe(v));
  })();
}
