// js/environments.js

export function initEnvironments() {
  const mql = window.matchMedia('(max-width: 900px)');

  const setup = () => {
    const toggles = document.querySelectorAll('.env-card .env-toggle');
    toggles.forEach(btn => {
      // Avoid duplicate listeners
      if (btn.dataset.bound === '1') return;
      btn.dataset.bound = '1';
      const card = btn.closest('.env-card');
      if (!card) return;
      const panelId = btn.getAttribute('aria-controls');
      const panel = panelId ? document.getElementById(panelId) : null;
      const setOpen = (open) => {
        if (!panel) return;
        if (open) {
          card.classList.add('is-open');
          panel.removeAttribute('hidden');
          btn.setAttribute('aria-expanded', 'true');
        } else {
          card.classList.remove('is-open');
          panel.setAttribute('hidden', '');
          btn.setAttribute('aria-expanded', 'false');
        }
      };

      // Initialize collapsed on load
      setOpen(false);

      const closeAllExcept = (exceptCard) => {
        document.querySelectorAll('.env-card.is-open').forEach(c => {
          if (c === exceptCard) return;
          c.classList.remove('is-open');
          const t = c.querySelector('.env-toggle');
          const p = c.querySelector('.env-details');
          if (t) t.setAttribute('aria-expanded', 'false');
          if (p) p.setAttribute('hidden', '');
        });
      };

      btn.addEventListener('click', (e) => {
        e.preventDefault();
        // Only apply accordion behavior on mobile viewports
        if (!mql.matches) return;
        const isOpen = card.classList.contains('is-open');
        if (isOpen) {
          setOpen(false);
        } else {
          closeAllExcept(card);
          setOpen(true);
        }
      });
    });
  };

  // Only meaningful on mobile, but harmless elsewhere
  setup();

  // If viewport crosses breakpoint, collapse panels
  mql.addEventListener?.('change', () => {
    if (!mql.matches) {
      document.querySelectorAll('.env-card.is-open').forEach(card => {
        card.classList.remove('is-open');
      });
      document.querySelectorAll('.env-details').forEach(p => p.setAttribute('hidden', ''));
      document.querySelectorAll('.env-toggle').forEach(b => b.setAttribute('aria-expanded', 'false'));
    }
  });
}
