// js/header.js

export function initHeader() {
  const header = document.querySelector('header');
  if (header) {
    const root = document.documentElement;
    const updateHeader = () => {
      const y = window.scrollY || window.pageYOffset;
      header.classList.toggle('is-solid', y > 24);
      header.classList.toggle('is-transparent', y <= 24);
    };

    const updateHeaderMetrics = () => {
      try {
        const rect = header.getBoundingClientRect();
        const cs = getComputedStyle(header);
        const top = parseFloat(cs.top) || 0;
        const offset = Math.ceil(rect.height + top);
        root.style.setProperty('--header-height', rect.height + "px");
        root.style.setProperty('--header-offset', offset + "px");
      } catch (e) {}
    };

    updateHeaderMetrics();
    updateHeader();
    let ticking = false;
    window.addEventListener('scroll', () => {
      if (!ticking) {
        window.requestAnimationFrame(() => {
          updateHeader();
          ticking = false;
        });
      }
    }, {
      passive: true
    });
    window.addEventListener('resize', () => {
      updateHeaderMetrics();
    });
    window.addEventListener('orientationchange', () => {
      setTimeout(updateHeaderMetrics, 150);
    });
  }
}
