// js/main.js

import { initUtils } from './utils.js';
import { initHeader } from './header.js';
import { initHero } from './hero.js';
import { initFeatures } from './features.js';
import { initBanner } from './banner.js';
import { initNavigation } from './navigation.js';
import { initNavDesktop } from './navDesktop.js';
import { initContactForm } from './contactForm.js';
import { initMobileCallBar } from './mobileCallBar.js';
import { initEnvironments } from './environments.js';

function initBackToTop() {
  const backToTopButton = document.getElementById('back-to-top');

  if (backToTopButton) {
    window.addEventListener('scroll', () => {
      if (window.pageYOffset > 300) {
        backToTopButton.style.display = 'block';
      } else {
        backToTopButton.style.display = 'none';
      }
    });

    backToTopButton.addEventListener('click', (e) => {
      e.preventDefault();
      window.scrollTo({
        top: 0,
        behavior: 'smooth'
      });
    });
  }
}

// No cookie gating required while no tracking is used

function initHeroAndUnlock() {
  initHero();
  requestAnimationFrame(() => {
    requestAnimationFrame(() => {
      setTimeout(() => {
        document.body.classList.remove('hero-lock');
      }, 80);
    });
  });
}

document.addEventListener('DOMContentLoaded', () => {
  // First-load lock to avoid mobile first-paint thrash
  document.body.classList.add('hero-lock');
  initUtils();
  initHeader();
  initFeatures();
  initBanner();
  initNavigation();
  // Enable click-to-open dropdowns on desktop (no overlay)
  initNavDesktop();
  initContactForm();
  initMobileCallBar();
  initEnvironments();
  initBackToTop();

  // Start hero immediately (no cookie banner required)
  setTimeout(() => {
    initHeroAndUnlock();
  }, 300);
});
