// js/mobileCallBar.js

export function initMobileCallBar() {
  const bar = document.getElementById('callBar');
  if (!bar) return;
  const closeBtn = bar.querySelector('.call-bar-close');
  const dismissed = () => (localStorage.getItem('callBarDismissed') === '1');
  const hide = () => {
    bar.classList.remove('show');
  };
  const show = () => {
    if (!dismissed()) bar.classList.add('show');
  };
  let shown = false;
  const onScroll = () => {
    const y = window.scrollY || window.pageYOffset || 0;
    if (!shown && y > 60) {
      show();
      shown = true;
    }
  };
  window.addEventListener('scroll', onScroll, {
    passive: true
  });
  if (closeBtn) closeBtn.addEventListener('click', () => {
    localStorage.setItem('callBarDismissed', '1');
    hide();
  });

  // Hide call bar while contact modal is open
  const contactModal = document.getElementById('contactModal');
  const closeContact = document.getElementById('closeContact');
  const openButtons = document.querySelectorAll('#openContact, #openContactHero, a[href="#contactModal"]');
  const hideForModal = () => hide();
  const maybeShowAfterModal = () => {
    if (!dismissed()) setTimeout(() => {
      if ((window.scrollY || 0) > 60) show();
    }, 300);
  };
  openButtons.forEach(b => b.addEventListener('click', hideForModal));
  if (closeContact) closeContact.addEventListener('click', maybeShowAfterModal);
  if (contactModal) contactModal.addEventListener('click', (e) => {
    if (e.target === contactModal) maybeShowAfterModal();
  });
}
