// js/navDesktop.js

export function initNavDesktop() {
  const nav = document.querySelector('header nav');
  if (!nav) return;

  // Do not apply when the mobile overlay is active
  const isOverlayActive = () => document.body.classList.contains('nav-open') || nav.classList.contains('open');

  // Close dropdown immediately when activating a link (mousedown + click, capture)
  const onActivate = (e) => {
    // Do not interfere with mobile overlay; let navigation.js handle it
    if (isOverlayActive()) return;
    const link = e.currentTarget;
    try {
      const href = link.getAttribute('href') || '';
      const url = new URL(href, window.location.href);
      const samePage = url.origin === window.location.origin && url.pathname === window.location.pathname && !!url.hash;

      // Force-close this dropdown (counter :hover persistence)
      const dd = link.closest('.nav-dropdown');
      if (dd) {
        dropdowns.forEach(o => o.classList.remove('dd-open'));
        dd.classList.add('dd-force-hide');
        // Keep hidden a bit länger, damit der Mauszeiger Zeit hat, den Header zu verlassen
        setTimeout(() => dd.classList.remove('dd-force-hide'), 800);
      }

      if (samePage) {
        const target = document.querySelector(url.hash);
        if (target) {
          // Only prevent default on the actual click, not mousedown
          if (e.type === 'click') e.preventDefault();
          target.scrollIntoView({ behavior: 'smooth' });
          // After scroll, focus the feature card if applicable
          setTimeout(() => {
            const card = target.classList.contains('feature') ? target : target.closest && target.closest('.feature');
            if (card) {
              document.querySelectorAll('.feature.is-focused').forEach(n => n.classList.remove('is-focused'));
              card.classList.add('is-focused');
              try { window.__featureUserFocusUntil = Date.now() + 1500; } catch (_) {}
            }
          }, 250);
        }
      }
    } catch (_) {
      // no-op
    }
  };
  // Attach click in capture phase to ensure early close, but avoid mousedown to not interfere with default navigation
  nav.querySelectorAll('.dropdown-content a').forEach(link => {
    link.addEventListener('click', onActivate, true);
  });

  // Toggle dropdowns on top-level click for stable interaction (no hover gap issues)
  const dropdowns = Array.from(nav.querySelectorAll('.nav-dropdown'));
  dropdowns.forEach(dd => {
    const trigger = dd.querySelector(':scope > a');
    if (!trigger) return;
    trigger.addEventListener('click', (e) => {
      if (isOverlayActive()) return; // overlay handles its own toggles
      // Prevent following the section link; open the dropdown instead
      e.preventDefault();
      // Close others
      dropdowns.forEach(other => { if (other !== dd) other.classList.remove('dd-open'); });
      // Toggle current
      dd.classList.toggle('dd-open');
    });
  });

  // Click outside to close any open dropdown
  document.addEventListener('click', (e) => {
    if (isOverlayActive()) return;
    if (!nav.contains(e.target)) {
      dropdowns.forEach(dd => dd.classList.remove('dd-open'));
    }
  });

  // Clean up on resize: if overlay becomes active, close desktop-open dropdowns
  window.addEventListener('resize', () => {
    if (isOverlayActive()) {
      dropdowns.forEach(dd => dd.classList.remove('dd-open'));
    }
  });
}
